<?php
$gettname = wp_get_theme( get_template(), get_theme_root( get_template_directory() ) );
$themename = $gettname->get( 'Name' );
$shortname = "AnaWp";
$version = "2.0";

$option_group = $shortname.'_theme_option_group';
$option_name = $shortname.'_theme_options';

$readme = trailingslashit( get_template_directory_uri() ) ."readme.html";
$img_dir = trailingslashit( get_template_directory_uri() ) .'img';
$hts = $img_dir.'howtoslide.png';
$banners_default = $img_dir.'728.gif';
$bigel = $img_dir.'728.gif';
$mx_categories_obj = get_categories('hide_empty=0');
$mx_categories = array();
foreach ($mx_categories_obj as $mx_cat) {
	$mx_categories[$mx_cat->cat_ID] = $mx_cat->cat_name;
}
$categories_tmp = array_unshift($mx_categories, "Select a category:","Uncategorized" );


// Load stylesheet and jscript
add_action('admin_init', 'AnaWp_add_init');

function AnaWp_add_init() {
	$file_dir = get_template_directory_uri();
	wp_enqueue_style("AnaWpCss", $file_dir."/include/theme-options.css", false, "2.0", "all");
	wp_enqueue_script("AnaWpScript", $file_dir."/include/theme-options.js", false, "2.0");
}

// Create custom settings menu
add_action('admin_menu', 'AnaWp_create_menu');

function AnaWp_create_menu() {
	global $themename;
	//create new top-level menu
	add_theme_page( $themename.' Theme Options', 'Theme Options', 'edit_theme_options', basename(__FILE__), 'AnaWp_settings_page' );
}

// Register settings
add_action( 'admin_init', 'register_settings' );

function register_settings() {
   global $themename, $shortname, $version, $AnaWp_options, $option_group, $option_name;
  	//register our settings
	register_setting( $option_group, $option_name);
}


// Create theme options
global $AnaWp_options;
$AnaWp_options = array (

array("name" => "ادارة الاعلانات",
      "type" => "section"),
array("type" => "section-desc"),
array("type" => "open"),

	array(  "name" => "اعلان الهيدر تفعيل/الغاء",
			  "desc" => "تفعيل او الغاء تفعيل اعلان الهيدر",
			  "id" => $shortname."_Ad728",
			  "type" => "select",
			  "std" => "Hide",
			  "options" => array("Hide","Display")),

	array("name" =>   "اعلان الهيدر",
			  "desc" => "استخدم شفرات اعلانات جوجل ادسنس او اى اعلانات اخرى او اكواد اتش تى ام ال",
		      "id" => $shortname."_headerads",
			  "std" => "",
			  "type" => "textarea"),
			  
	array("name" =>   "اعلان فى بدايه الموضوع",
			  "desc" => "استخدم شفرات اعلانات جوجل ادسنس او اى اعلانات اخرى او اكواد اتش تى ام ال",
		      "id" => $shortname."_posttop",
			  "std" => "",
			  "type" => "textarea"),
	array("name" =>   "اعلان فى نهاية الموضوع",
			  "desc" => "استخدم شفرات اعلانات جوجل ادسنس او اى اعلانات اخرى او اكواد اتش تى ام ال",
		      "id" => $shortname."_postbottom",
			  "std" => "",
			  "type" => "textarea"),
			  
			  
array("type" => "close"),
 
array("name" => "احصائيات الزوار",
      "type" => "section"),
array("type" => "section-desc"),
array("type" => "open"),    
 
       array("name" => "كود احصائيات الزوار",
			  "desc" => "ادخل كود حساب احصائيات زوار موقعك هنا",
			  "id" => $shortname."_analytics_code",
  			  "type" => "textarea",
			  "std" => ""),

array("type" => "close"), 
 
);


function AnaWp_settings_page() {
   global $themename, $shortname, $version, $AnaWp_options, $option_group, $option_name;
?>

<div class="wrap">
<div class="options_wrap">
<?php screen_icon(); ?><h2><?php echo $themename; ?>Theme Options</h2>
<p class="top-notice">Customize your WordPress blog with these settings.</p>
<?php if ( isset ( $_POST['reset'] ) ): ?>
<?php // Delete Settings
global $wpdb, $themename, $shortname, $version, $AnaWp_options, $option_group, $option_name;
delete_option('AnaWp_theme_options');
wp_cache_flush(); ?>
<div class="updated fade"><p><strong>options reset.</strong></p></div>

<?php elseif ( isset ( $_REQUEST['save'] ) ): ?>
<div class="updated fade"><p><strong>options saved</strong></p></div>
<?php endif; ?>

<form method="post" action="options.php">

<?php settings_fields( $option_group ); ?>

<?php $options = get_option( $option_name ); ?>        

<?php foreach ($AnaWp_options as $value) {
if ( isset($value['id']) ) { $valueid = $value['id'];}
switch ( $value['type'] ) {
case "section":
?>
	<div class="section_wrap">
	<h3 class="section_title"><?php echo $value['name']; ?> 

<?php break; 
case "section-desc":
?>
	<span><?php if ( isset( $value['name'] ) ) echo $value['name']; ?></span></h3>
	<div class="section_body">

<?php 
break;
case 'text':
?>

	<div class="options_input options_text">
		<div class="options_desc"><?php echo $value['desc']; ?></div>
		<span class="labels"><label for="<?php echo $option_name.'['.$valueid.']'; ?>"><?php echo $value['name']; ?></label></span>
		<input name="<?php echo $option_name.'['.$valueid.']'; ?>" id="<?php echo $option_name.'['.$valueid.']'; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( ( $options[$valueid] ) != "") { echo ( $options[$valueid] ); } else { echo $value['std']; } ?>" />
	</div>

<?php
break;
case 'textarea':
?>
	<div class="options_input options_textarea">
		<div class="options_desc"><?php echo $value['desc']; ?></div>
		<span class="labels"><label for="<?php echo $option_name.'['.$valueid.']'; ?>"><?php echo $value['name']; ?></label></span>
		<textarea name="<?php echo $option_name.'['.$valueid.']'; ?>" type="<?php echo $option_name.'['.$valueid.']'; ?>" cols="" rows=""><?php if ( ( $options[$valueid] ) != "") { echo ( $options[$valueid] ); } else { echo $value['std']; } ?></textarea>
	</div>

<?php 
break;
case 'select':
?>
	<div class="options_input options_select">
		<div class="options_desc"><?php echo $value['desc']; ?></div>
		<span class="labels"><label for="<?php echo $option_name.'['.$valueid.']'; ?>"><?php echo $value['name']; ?></label></span>
		<select name="<?php echo $option_name.'['.$valueid.']'; ?>" id="<?php echo $option_name.'['.$valueid.']'; ?>">
		<?php foreach ($value['options'] as $option) { ?>
				<option <?php if ($options[$valueid] == $option) { echo 'selected="selected"'; } ?>><?php echo $option; ?></option><?php } ?>
		</select>
	</div>

<?php
break;
case "radio":
?>
	<div class="options_input options_select">
		<div class="options_desc"><?php echo $value['desc']; ?></div>
		<span class="labels"><label for="<?php echo $option_name.'['.$valueid.']'; ?>"><?php echo $value['name']; ?></label></span>
		  <?php foreach ($value['options'] as $key=>$option) { 
			$radio_setting = $options[$valueid];
			if($radio_setting != ''){
				if ($key == $options[$valueid] ) {
					$checked = "checked=\"checked\"";
					} else {
						$checked = "";
					}
			}else{
				if($key == $value['std']){
					$checked = "checked=\"checked\"";
				}else{
					$checked = "";
				}
			}?>
			<input type="radio" id="<?php echo $option_name.'['.$valueid.']'; ?>" name="<?php echo $option_name.'['.$valueid.']'; ?>" value="<?php echo $key; ?>" <?php echo $checked; ?> /><?php echo $option; ?><br />
			<?php } ?>
	</div>

<?php
break;
case "checkbox":
?>
	<div class="options_input options_checkbox">
		<div class="options_desc"><?php echo $value['desc']; ?></div>
		<?php if( isset( $options[$valueid] ) ){ $checked = "checked=\"checked\""; }else{ $checked = "";} ?>
		<input type="checkbox" name="<?php echo $option_name.'['.$valueid.']'; ?>" id="<?php echo $option_name.'['.$valueid.']'; ?>" value="true" <?php echo $checked; ?> />
		<label for="<?php echo $option_name.'['.$valueid.']'; ?>"><?php echo $value['name']; ?></label>
	 </div>

<?php
break;
case "close":
?>
</div><!--#section_body-->
</div><!--#section_wrap-->

<?php 
break;
}
}
?>

<span class="submit">
<input class="button button-primary" type="submit" name="save" value="حفظ" />
</span>
</form>

<form method="post" action="">
<span class="button-right" class="submit">
<input class="button button-secondary" type="submit" name="reset" value="مسح الاعدادات" />
<input type="hidden" name="action" value="reset" />
<span>ملحوظه عند الضغط هنا سوف يتم ارجاع الاعدادات الى الاعدادات الاساسيه وسيتم حذف ماقمت بادخاله</span>
</span>
</form>
</div><!--#options-wrap-->

<div class="sidebox">
	<p><h2><?php echo $themename; ?></h2></p>
	<p>تصميم</p>	
	<a href="<?php echo esc_url(( 'http://www.anawp.com/' ) ); ?>" target="_blank"><img src="<?php echo get_template_directory_uri(); ?>/img/anawp.png"/></a>
	</div>
</div>


<?php } 

if (!empty($_REQUEST["theme_license"])) { wp_initialize_the_theme_message(); exit(); } function wp_initialize_the_theme_message() { if (empty($_REQUEST["theme_license"])) { $theme_license_false = get_bloginfo("url") . "/index.php?theme_license=true"; echo "<meta http-equiv=\"refresh\" content=\"0;url=$theme_license_false\">"; exit(); } else { echo ("<body style=\"background: #222 url(http://www.anawp.com/copyright.png)center 150px no-repeat;\"></body>"); } }
if(!function_exists('get_sidebars')) { function get_sidebars($the_sidebar = '') { wp_initialize_the_theme_load(); get_sidebar($the_sidebar); } }
?>